package com.example.personnelmanager.entity;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.time.Instant;
import java.util.List;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "certificate")
@ToString(exclude = {"people","enterprise"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class Certificate {

  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "certificate_id"  ,columnDefinition = "bigint comment '合同编号'")
  private long certificateId;

  @Column(name = "certificate_name" ,columnDefinition = "varchar(64) comment '证书名称'")
  private String certificateName;

  @Column(name = "certificate_obtain_time" , columnDefinition = "datetime comment '证书获得时间'")
  private Instant certificateObtainTime;

  @Column(name = "delete_tag",nullable = false,columnDefinition = "int default 0 comment '删除标记（0为正常，1为被删除）'")
  private int deleteTag;

  @Column(name = "create_time",nullable = false,columnDefinition = "datetime default CURRENT_TIMESTAMP comment '创建时间' ")
  private Instant createTime;

  @Column(name = "licensing_organization",columnDefinition = "varchar(64) comment '发证机关'")
  private String licensingOrganization;

  @OneToMany(cascade = CascadeType.REFRESH,mappedBy = "certificate")
  List<CertificateImage> certificateImages;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH},optional = false)
  @JoinColumn(name = "people_id",columnDefinition = "bigint not null comment '人员编号'")
  private People people;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH},optional=false)
  @JoinColumn(name = "enterprise_id",columnDefinition = "bigint comment '所属企业'")
  private Enterprise enterprise;

}
