package com.example.personnelmanager.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.time.Instant;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "job_transfer_information")
@ToString(exclude = {"people"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class JobTransferInformation {

  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "transfer_id",columnDefinition = "bigint comment '调岗记录编号' ")
  private long transferId;

  @OneToOne(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
  @JoinColumn(name = "before_Post_id",columnDefinition = "bigint comment '换岗前岗位编号' ")
  private Post beforePost;

  @OneToOne(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
  @JoinColumn(name = "after_Post_id",columnDefinition = "bigint comment '换岗后岗位编号' ")
  private Post afterPost;

  @Lob
  @Column(name = "transfer_information",columnDefinition = "text comment '备注' ")
  private String transferInformation;

  @Column(name = "delete_tag",nullable = false,columnDefinition = "int default 0 comment '删除标记'")
  private int deleteTag;

  @Column(name = "create_time",nullable = false,columnDefinition = " datetime default CURRENT_TIMESTAMP comment '删除标记（0为正常，1为被删除）'")
  private Instant createTime;

  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH})
  @JoinColumn(name = "people_id",columnDefinition = "bigint comment '所属人员'")
  private People people;

}
