package com.example.personnelmanager.entity;

import com.example.personnelmanager.common.validIGroup.GroupDelete;
import com.example.personnelmanager.common.validIGroup.GroupGetOne;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.time.Instant;
import java.util.List;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "organization_node")
@ToString(exclude = {"enterprise","posts","duties","legalEntity","legalEntity"})
public class OrganizationNode {

  @Max(value = 0,groups = {GroupSave.class} )
  @NotNull(groups = {GroupDelete.class, GroupGetOne.class, GroupUpdate.class})
  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "node_id",columnDefinition = "bigint comment '节点编号' ")
  private long nodeId;

  @NotNull(groups = {GroupSave.class},message = "节点名称不能为空")
  @Column(name = "node_name",nullable = false,columnDefinition = "varchar(64) comment '节点名称' ")
  private String nodeName;

  @Min(value = 0,groups = {GroupUpdate.class})
  @NotNull(groups = {GroupSave.class},message = "上级节点不能为空")
  @Column(name = "parent_node",columnDefinition = "bigint comment '上级节点' ")
  private long parentNode;

  @NotNull(groups = {GroupSave.class},message = "节点类型不能为空")
  @Column(name = "node_type",columnDefinition = "varchar(32) comment '节点类型' ")
  private String nodeType;

  @Column(name = "create_time",nullable = false,columnDefinition = " datetime default CURRENT_TIMESTAMP comment '删除标记（0为正常，1为被删除）'")
  private Instant createTime;

  @Lob
  @Column(name = "node_profile",columnDefinition = "text comment '节点简介' ")
  private String nodeProfile;

  @Column(name = "delete_tag",nullable = false,columnDefinition = "int default 0 comment '删除标记'")
  private int deleteTag;

  @Lob
  @Column(name = "node_level",nullable = false,columnDefinition = "text comment '节点等级 例如0.1.4.5 这些数字代表的节点的父节点之间的关系'")
  private String nodeLevel;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH})
  @JoinColumn(name = "enterprise_id",columnDefinition = "bigint comment '所属企业'")
  private Enterprise enterprise;

  @ManyToOne(cascade={CascadeType.REFRESH})
  @JoinColumn(name = "legal_entity_id",columnDefinition = "bigint comment '法律实体编号'")
  private LegalEntity legalEntity;

  @ManyToOne(cascade={CascadeType.REFRESH})
  @JoinColumn(name = "work_place_id",columnDefinition = "bigint comment '工作地点编号'")
  private WorkPlace workPlace;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @OneToMany(cascade = CascadeType.REFRESH,mappedBy = "organizationNode")
  private List<Post> posts;

  @Transient
  private List<OrganizationNode> childeNodes;

}
