package com.example.personnelmanager.entity;


import com.example.personnelmanager.common.validIGroup.GroupDelete;
import com.example.personnelmanager.common.validIGroup.GroupGetOne;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.models.auth.In;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "people")
@ToString(exclude = {"enterprise"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class People {

  @Id
  @NotNull(groups = {GroupDelete.class, GroupGetOne.class, GroupUpdate.class})
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "people_id")
  private long peopleId;

  @NotNull(groups = {GroupSave.class})
  @Column(name = "name",nullable = false,columnDefinition = "varchar(16) comment '所属企业'")
  private String name;

  @Column(name = "sex",columnDefinition = "varchar(8) comment '性别'")
  private String sex;

  @Column(name = "age",columnDefinition = "int comment '年龄'")
  private int age;

  @NotNull(groups = {GroupSave.class})
  @Column(name = "phone",nullable = false,columnDefinition = "varchar(16) comment '手机号码'")
  private String phone;

  @Column(name = "working_number",columnDefinition = "varchar(16) comment '工号'")
  private String workingNumber;

  @Column(name = "working_age",columnDefinition = "decimal(8,1) comment '工龄'")
  private double workingAge;

  @Column(name = "history_working_age",columnDefinition = "decimal(8,1) comment '历史工龄'")
  private double historyWorkingAge;

  @Column(name = "politic_countenance",columnDefinition = "varchar(16) comment '政治面貌'")
  private String politicCountenance;

  @Column(name = "birthday",columnDefinition = "datetime comment '出生日期'")
  private Instant birthday;

  @Column(name = "native_place",columnDefinition = "varchar(32) comment '籍贯'")
  private String nativePlace;

  @Column(name = "id_card_type",columnDefinition = "varchar(8) comment '身份证件类型（身份证、护照、居留'")
  private String idCardType;

  @Column(name = "id_card_number",columnDefinition = "varchar(32) comment '身份证件号码'")
  private String idCardNumber;

  @Column(name = "id_card_address",columnDefinition = "varchar(32) comment '身份证件号码'")
  private String idCardAddress;

  @Lob
  @Column(name = "id_card_front_url",columnDefinition = "text comment '证件正面照'")
  private String idCardFrontUrl;

  @Lob
  @Column(name = "id_card_back_url",columnDefinition = "text comment '证件背面照'")
  private String idCardBackUrl;

  @Column(name = "id_card_is_long_validity",columnDefinition = "bool default false comment '证件是否长期有效'")
  private boolean idCardIsLongValidity;

  @Column(name = "id_card_validity_date",columnDefinition = "datetime comment '证件有效期'")
  private Instant idCardValidityDate;

  @Column(name = "marital_status",columnDefinition = "varchar(8) comment '婚姻状况(已婚、未婚)'")
  private String maritalStatus;

  @Column(name = "census_register_type",columnDefinition = "varchar(8) comment '户籍类型(农业、非农)'")
  private String censusRegisterType;

  @Column(name = "social_security_account",columnDefinition = "varchar(255) comment '个人社保账号'")
  private String socialSecurityAccount;

  @Column(name = "accumulation_fund_account",columnDefinition = "varchar(255) comment '个人公积金账号'")
  private String accumulationFundAccount;

  @Column(name = "paycard_number",columnDefinition = "varchar(255) comment '工资卡卡号'")
  private String paycardNumber;

  @Column(name = "paycard_bank",columnDefinition = "varchar(32) comment '工资卡开户行'")
  private String paycardBank;

  @Column(name = "job_status",columnDefinition = "varchar(8) comment '在职状态具有以下几种：在职、离职、待入职、实习、试用、退休。其中实习、试用由用户填写的试用结束时间和实习结束时间决定，若用户填写实习结束时间并且时间晚于当前时间则人员处于实习状态，若用户填写试用结束时间并且时间晚于当前时间则人员处于试用状态。其余状态由用户手动变更'")
  private String jobStatus;

  @Column(name = "highest_education",columnDefinition = "varchar(16) comment '最高学历(初中、高中、大专/高职、本科、硕士/MBA/EMBA、博士、其他)'")
  private String highestEducation;

  @Column(name = "qq_number",columnDefinition = "varchar(64) comment 'QQ号码'")
  private String qqNumber;

  @Column(name = "wechat_number",columnDefinition = "varchar(255) comment '微信号码'")
  private String wechatNumber;

  @Column(name = "mail",columnDefinition = "varchar(255) comment '个人邮箱'")
  private String mail;

  @Column(name = "current_residence",columnDefinition = "varchar(255) comment '现居住地'")
  private String currentResidence;

  @NotNull(groups = {GroupSave.class})
  @Column(name = "entry_time",nullable = false,columnDefinition = "datetime comment '入职时间'")
  private Instant entryTime;

  @Column(name = "internship_end_time",columnDefinition = "datetime comment '实习结束时间'")
  private Instant internshipEndTime;

  @Column(name = "trial_end_time",columnDefinition = "datetime comment '试用结束时间'")
  private Date trialEndTime;

  @Column(name = "deleteTag",nullable = false,columnDefinition = "int default 0 comment '删除标记（0为正常，1为被删除）' ")
  private int deleteTag;

  @Column(name = "create_time",nullable = false,columnDefinition = "datetime default CURRENT_TIMESTAMP comment '创建时间' ")
  private Instant createTime;

  @Max(value = 0,message = "所属企业不允许被修改",groups = {GroupUpdate.class})
  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH},optional=false)
  @JoinColumn(name = "enterprise_id",columnDefinition = "bigint comment '所属企业'")
  private Enterprise enterprise;

  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH,mappedBy = "people")
  private List<Certificate> certificates ;

  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH,mappedBy = "people")
  private List<Contract> contracts;

  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH,mappedBy = "people")
  private List<EducationalExperience> educationalExperiences;

  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH,mappedBy = "people")
  private List<Urgent> urgents;

  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH,mappedBy = "people")
  private List<Title> titles;

  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH,mappedBy = "people")
  private List<JobTransferInformation> jobTransferInformations;

  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH,mappedBy = "people")
  private List<LeaveInformation> leaveInformations;

  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH,mappedBy = "people")
  private List<WorkExperience> workExperiences;

}
