package com.example.personnelmanager.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class PeoplePost
 * @packageName com.example.personnelmanager.entity
 * @data 2020/5/14
 **/
@Entity
@DynamicUpdate
@DynamicInsert
@Table(name = "people_post")
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class PeoplePost implements Serializable {

    private static final long serialVersionUID = 1207408282047173539L;

    @Id
    @ManyToOne()
    @JoinColumn(name="people_id")
    private People people;

    @Id
    @ManyToOne()
    @JoinColumn(name="post_id")
    private Post post;
}
