package com.example.personnelmanager.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.time.Instant;
import java.util.List;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@ToString(exclude = {"organizationNode","enterprise","duty"})
@Table(name = "post")
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class Post {

  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "post_id",columnDefinition = "bigint comment '岗位编号' ")
  private long postId;

  @Column(name = "post_name",nullable = false,columnDefinition = "varchar(64) comment '岗位名称' ")
  private String postName;

  @Column(name = "post_type",columnDefinition = "varchar(32) comment '岗位类别' ")
  private String postType;

  @Lob
  @Column(name = "node_level",nullable = false,columnDefinition = "text comment '所属节点等级 例如0.1.4.5 具体解释请参考组织节点表，本属性与组织节点表同步，在此处添加该属性主要目的是为了增加查询'")
  private String nodeLevel;

  @Column(name = "create_time",nullable = false,columnDefinition = "datetime default CURRENT_TIMESTAMP comment '创建时间' ")
  private Instant createTime;

  @Lob
  @Column(name = "post_introduction",columnDefinition = "text comment '岗位简介' ")
  private String postIntroduction;

  @Column(name = "deleteTag",nullable = false,columnDefinition = "int default 0 comment '删除标记（0为正常，1为被删除）' ")
  private int deleteTag;

  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH})
  @JoinColumn(name = "enterprise_id",columnDefinition = "bigint comment '所属企业'")
  private Enterprise enterprise;

  @ManyToOne(cascade={CascadeType.REFRESH})
  @JoinColumn(name = "node_id",columnDefinition = "bigint comment '所属节点'")
  private OrganizationNode organizationNode;

  @Transient
  private List<People> peoples;

}
