package com.example.personnelmanager.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.time.Instant;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "title_image")
@ToString(exclude = {"title"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class TitleImage {

  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "title_image_id",columnDefinition = "bigint comment '职称照片' ")
  private long titleImageId;

  @Lob
  @Column(name = "url",columnDefinition = "text comment '图片地址' ")
  private String url;

  @Column(name = "deleteTag",nullable = false,columnDefinition = "int default 0 comment '删除标记（0为正常，1为被删除）' ")
  private int deleteTag;

  @Column(name = "create_time",nullable = false,columnDefinition = "datetime default CURRENT_TIMESTAMP comment '创建时间' ")
  private Instant createTime;

  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH},optional = false)
  @JoinColumn(name = "title_id",nullable = false,columnDefinition = "bigint comment '职称编号'")
  private Title title;
}
