package com.example.personnelmanager.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.time.Instant;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "urgent")
@ToString(exclude = {"people"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class Urgent {

  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "urgent_id",columnDefinition = "bigint comment '紧急联系人编号'")
  private long urgentId;

  @Column(name = "name",columnDefinition = "varchar(8) not null comment '姓名'")
  private String name;

  @Column(name = "relation",columnDefinition = "varchar(16) comment '关系'")
  private String relation;

  @Column(name = "phone",columnDefinition = "varchar(16) comment '电话'")
  private String phone;

  @Column(name = "address",columnDefinition = "varchar(255) comment '住址'")
  private String address;

  @Column(name = "delete_tag",columnDefinition = "int default 0 comment '删除标记（0为正常，1为被删除）'")
  private int deleteTag;

  @Column(name = "create_date",nullable = false,columnDefinition = "datetime default CURRENT_TIMESTAMP comment '创建时间'")
  private Instant createTime;

  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH})
  @JoinColumn(name = "people_id",columnDefinition = "bigint comment '所属人员'")
  private People people;

}
