package com.example.personnelmanager.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class User_Enterprise
 * @packageName com.example.personnelmanager.entity
 * @data 2020/5/14
 **/

@Entity
@DynamicUpdate
@DynamicInsert
@Table(name = "user_enterprise")
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class UserAndEnterprise implements Serializable {

    private static final long serialVersionUID = 1207408297047174539L;

    @Id
    @ManyToOne()
    @JoinColumn(name="user_id")
    private User user;

    @Id
    @ManyToOne()
    @JoinColumn(name="enterprise_id")
    private Enterprise enterprise;


}
