package com.example.personnelmanager.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.time.Instant;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "work_experience")
@ToString(exclude = {"people"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class WorkExperience {

  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "work_experience_id",columnDefinition = "bigint comment '工作经历编号'")
  private long workExperienceId;

  @Column(name = "post",columnDefinition = "varchar(16) comment '职务'")
  private String post;

  @Column(name = "work_end_time",nullable = false,columnDefinition = "datetime comment '用户编号'")
  private Instant workEndTime;

  @Column(name = "work_start_time",nullable = false,columnDefinition = "datetime comment '工作结束时间'")
  private Instant workStartTime;

  @Column(name = "leave_reason",columnDefinition = "varchar(255) comment '离职原因'")
  private String leaveReason;

  @Column(name = "witness",columnDefinition = "varchar(8) comment '证明人'")
  private String witness;

  @Column(name = "witness_phone",columnDefinition = "varchar(16) comment '证明人电话'")
  private String witnessPhone;

  @Column(name = "delete_tag",nullable = false,columnDefinition = "int default 0 comment '删除标记（0为正常，1为被删除）'")
  private long deleteTag;

  @Column(name = "create_date",nullable = false,columnDefinition = "datetime default CURRENT_TIMESTAMP comment '创建时间'")
  private Instant createTime;

  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH})
  @JoinColumn(name = "people_id",columnDefinition = "bigint comment '所属人员'")
  private People people;


}
