package com.example.personnelmanager.entity;


import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import sun.security.jgss.GSSCaller;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.Instant;
import java.util.List;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "work_place")
@ToString(exclude = {"enterprise","organizationNodes"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class WorkPlace {

  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "work_place_id",columnDefinition = "bigint comment '工作地点编号'")
  private long workPlaceId;

  @NotNull(groups = {GroupSave.class, GroupUpdate.class})
  @Column(name = "work_place_name",nullable = false,columnDefinition = "varchar(64) comment '工作地点名称'")
  private String workPlaceName;

  @NotNull(groups = {GroupSave.class, GroupUpdate.class})
  @Column(name = "work_place_area",nullable = false,columnDefinition = "varchar(64) comment '工作地点地区'")
  private String workPlaceArea;

  @Column(name = "work_place_address",columnDefinition = "varchar(255) comment '详细地址'")
  private String workPlaceAddress;

  @Column(name = "work_place_type",columnDefinition = "varchar(8) comment '类型'")
  private String workPlaceType;

  @Lob
  @Column(name = "work_place_descript",columnDefinition = "text comment '描述'")
  private String workPlaveDescript;

  @Column(name = "delete_tag",columnDefinition = "int default 0 comment '删除标记（0为正常，1为被删除）'")
  private long deleteTag;

  @Column(name = "create_time",columnDefinition = "datetime default CURRENT_TIMESTAMP comment '创建时间'")
  private Instant createTime;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH})
  @JoinColumn(name = "enterprise_id",columnDefinition = "bigint comment '所属企业'")
  private Enterprise enterprise;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH,mappedBy = "workPlace")
  private List<OrganizationNode> organizationNodes;


}
