package com.example.personnelmanager.entity.dto;

import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class WorkPlaceRequestDto
 * @packageName com.example.personnelmanager.entity.dto
 * @data 2020/5/20
 **/
@Data
public class WorkPlaceDto {

    @Min(value = 1,groups = {GroupUpdate.class})
    @Max(value = 0,groups = {GroupSave.class})
    private long workPlaceId;

    @NotNull(groups = {GroupSave.class,GroupUpdate.class},message = "工作地点名称不能为空")
    private String workPlaceName;

        private String workPlaceArea;

    private String workPlaceAddress;

    private String workPlaceType;

    private String workPlaveDescript;


}
