package com.example.personnelmanager.service;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.dao.CertificateRepository;
import com.example.personnelmanager.entity.Certificate;
import com.example.personnelmanager.entity.UserDetail;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class CertificateServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/18
 **/

@Service
public class CertificateServiceImpl implements CertificateService {

    @Autowired
    CertificateRepository certificateRepository;

    @Override
    public Certificate addEntity(Certificate certificate) {
        UserDetail userDetails = (UserDetail) AuthenticationUtils.getAuthentication();
        certificate.setEnterprise(userDetails.getEnterprise());
        Certificate save = certificateRepository.save(certificate);
        return save;
    }

    @Override
    public Page<Certificate> getList(Certificate certificate, Pageable pageable) {
        UserDetail userDetails = (UserDetail) AuthenticationUtils.getAuthentication();
        if (userDetails==null){
            throw new UsernameNotFoundException("当前无登录用户");
        }
        if (userDetails.getEnterprise()==null){
            throw new UsernameNotFoundException("当前登录用户无权限查看该单位信息");
        }
        PredicateBuilder and = Specifications.<Certificate>and();
        and.eq("peopleId",certificate.getPeople().getPeopleId());
        and.eq("enterprise", userDetails.getEnterprise().getEnterpriseId());
        and.eq("deleteTag", 0);
        Specification<Certificate> specification = and.build();
        Page<Certificate> all = certificateRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    public Certificate update(Certificate certificate) {
        Certificate after = certificateRepository.saveAndFlush(certificate);
        return after;
    }

    @Override
    public Certificate getOne(Long id) {
        Optional<Certificate> byId = certificateRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的合同不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<Certificate> byId = certificateRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的合同");
        }
        Certificate certificate = byId.get();
        certificate.setDeleteTag(1);
        certificateRepository.saveAndFlush(certificate);
        return true;
    }
}
