package com.example.personnelmanager.service;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.dao.PeopleRepository;
import com.example.personnelmanager.entity.People;
import com.example.personnelmanager.entity.UserDetail;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class LegalEntityServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/13
 **/

@Service
public class PeopleServiceImpl implements PeopleService {

    @Autowired
    PeopleRepository peopleRepository;

    @Override
    public People addEntity(People people) {
        UserDetail userDetails = (UserDetail) AuthenticationUtils.getAuthentication();
        if (peopleRepository.findByPhoneAndEnterprise(people.getPhone(),userDetails.getEnterprise().getEnterpriseId()).size()>0){
            throw new GlobalException("手机号码与其他人员重复");
        }
        if (people.getInternshipEndTime()!=null){
            people.setJobStatus("实习");
        }else
        if (people.getInternshipEndTime()!=null){
            people.setJobStatus("试用");
        }else {
            people.setJobStatus("在职");
        }
        people.setEnterprise(userDetails.getEnterprise());
        People save = peopleRepository.saveAndFlush(people);
        return save;
    }

    @Override
    public Page<People> getList(People people, Pageable pageable) {
        UserDetail userDetails = (UserDetail) AuthenticationUtils.getAuthentication();
        if (userDetails==null){
            throw new UsernameNotFoundException("当前无登录用户");
        }
        if (userDetails.getEnterprise()==null){
            throw new UsernameNotFoundException("当前登录用户无权限查看该单位信息");
        }
        PredicateBuilder and = Specifications.<People>and();
        if (people!=null){
//            if (!StringUtils.isEmpty(workPlace.getWorkPlaceArea())){
//                and.like("taxDeclarationArea","%"+workPlace.getWorkPlaceArea()+"%");
//            }
        }
        and.eq("enterprise", userDetails.getEnterprise().getEnterpriseId());
        and.eq("deleteTag", 0);
        Specification<People> specification = and.build();
        Page<People> all = peopleRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    public People update(People people) {
        UserDetail userDetails = (UserDetail) AuthenticationUtils.getAuthentication();
        if (peopleRepository.findByPhoneAndEnterprise(people.getPhone(),userDetails.getEnterprise().getEnterpriseId()).size()>0){
            throw new GlobalException("手机号码与其他人员重复");
        }
        People after = peopleRepository.saveAndFlush(people);
        return after;
    }

    @Override
    public People getOne(Long id) {
        Optional<People> byId = peopleRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的工作地点不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<People> byId = peopleRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的人员");
        }
        People people = byId.get();
        people.setDeleteTag(1);
        peopleRepository.saveAndFlush(people);
        return true;
    }
}
