package com.example.personnelmanager.service;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.dao.PostRepository;
import com.example.personnelmanager.entity.OrganizationNode;
import com.example.personnelmanager.entity.Post;
import com.example.personnelmanager.entity.UserDetail;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class LegalEntityService
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/13
 **/

@Service
public class PostServiceImpl implements PostService {

    @Autowired
    PostRepository postRepository;

    @Autowired
    OrganizationNodeService organizationNodeService;

    @Override
    public Post addEntity(Post post) {
        UserDetail userDetails = (UserDetail) AuthenticationUtils.getAuthentication();
        OrganizationNode one = organizationNodeService.getOne(post.getOrganizationNode().getNodeId());
        if (one.getEnterprise().getEnterpriseId() != userDetails.getEnterprise().getEnterpriseId()) {
            throw new UsernameNotFoundException("当前登录用户无权限操作该父节点");
        }
        post.setNodeLevel(one.getNodeLevel());
        post.setEnterprise(userDetails.getEnterprise());
        Post save = postRepository.saveAndFlush(post);
        return save;
    }

    @Override
    public Page<Post> getList(Post post, Pageable pageable) {
        UserDetail userDetails = (UserDetail) AuthenticationUtils.getAuthentication();
        if (userDetails == null) {
            throw new UsernameNotFoundException("当前无登录用户");
        }
        if (userDetails.getEnterprise() == null) {
            throw new UsernameNotFoundException("当前登录用户无权限查看该单位信息");
        }
        PredicateBuilder and = Specifications.<Post>and();
        if (post != null) {
            if (!StringUtils.isEmpty(post.getPostName())){
                and.like("postName","%"+post.getPostName()+"%");
            }
            if (post.getOrganizationNode()!=null&&post.getOrganizationNode().getNodeId()>0){
                and.eq("organizationNode",post.getOrganizationNode().getNodeId());
            }
        }
        and.eq("enterprise", userDetails.getEnterprise().getEnterpriseId());
        and.eq("deleteTag", 0);
        Specification<Post> specification = and.build();
        Page<Post> all = postRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    public Post update(Post post) {
        Post after = postRepository.saveAndFlush(post);
        return after;
    }

    @Override
    public Post getOne(Long id) {
        Optional<Post> byId = postRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的工作地点不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<Post> byId = postRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的工作地点");
        }
        Post post = byId.get();
        post.setDeleteTag(1);
        postRepository.saveAndFlush(post);
        return true;
    }
}
