package com.example.personnelmanager.common.utils;

import com.example.personnelmanager.dao.OrganizationNodeRepository;
import com.example.personnelmanager.dao.PeopleRepository;
import com.example.personnelmanager.dao.UserRepository;
import com.example.personnelmanager.entity.OrganizationNode;
import com.example.personnelmanager.entity.People;
import com.example.personnelmanager.entity.User;
import com.example.personnelmanager.entity.commonEntity.CustomOrder;
import com.example.personnelmanager.entity.commonEntity.CustomPage;
import com.example.personnelmanager.service.UserServer;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class DateCenterUtil
 * @packageName com.example.personnelmanager.common.utils
 **/
@Component
public class DateCenterUtil {

    @Autowired
    PeopleRepository peopleRepository;

    @Autowired
    OrganizationNodeRepository organizationNodeRepository;

    @Autowired
    HttpClientUtil httpClientUtil;

    @Autowired
    DateCenterJsonUtil jsonUtil;

    @Autowired
    UserServer userServer;

    @Autowired
    UserRepository userRepository;

    public void sendDateToCenter(){
//      将数据库中的人员数据存放到数据中心
        List<People> allPeople = peopleRepository.findAll();
            httpClientUtil.post("http://124.70.194.194:8090/opt/data", jsonUtil.initAllPeopleJsonStr(allPeople), "utf-8");
//      将数据库中的部门信息存放到数据中心
        List<OrganizationNode> allNode = organizationNodeRepository.findAll();
        httpClientUtil.post("http://124.70.194.194:8090/opt/data", jsonUtil.initAllOrganizationNodeJsonStr(allNode), "utf-8");
    };

    public void initUser(){
        List<People> all = peopleRepository.findAll();
        //初始化登录中心的用户
//        httpClientUtil.post("http://127.0.0.1:12346/user/addUserList", jsonUtil.initUserJsonStr(all), "utf-8");
        //初始化本系统用户
        for (int i = 0; i < all.size(); i++) {
            People people = all.get(i);
            User user = new User();
            user.setUsername(people.getName());
            //判断用户名字是否在数据库中重复，如果重复则为用户名后面加上对应的重复次数，例如张三01
            PredicateBuilder<User> and = Specifications.and();
            and.eq("name",user.getName());
            CustomPage customPage = new CustomPage();
            customPage.setOrders(Arrays.asList(new CustomOrder("name", Sort.Direction.DESC)));
            Page<User> users = userRepository.findAll(and.build(), customPage.getPageable());
            if (users.getContent().size()>0){
                User userRepeat = users.getContent().get(0);
                user.setUsername(user.getName()+(userRepeat.getRepeatsNum()+1));
            }
            user.setAdministrator(false);
            user.setCreateDate(Instant.now());
            user.setName(people.getName());
            user.setPassword("qwer1234");
            user.setEnterprise(people.getEnterprise());
            user.setPhone(people.getPhone());
            userServer.addEntity(user);
        }

    }
}
