package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.Urgent;
import com.example.personnelmanager.entity.commonEntity.ResultObj;
import com.example.personnelmanager.entity.vo.pageableVo.UrgentPageableVo;
import com.example.personnelmanager.service.UrgentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class UrgentController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/27
 **/

@RestController
@RequestMapping("/api/urgent")
public class UrgentController {

    @Autowired
    UrgentService urgentService;

    @RequestMapping(method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj addUrgent(@Validated(GroupSave.class) @RequestBody Urgent urgent){
        Urgent addUrgent = urgentService.addEntity(urgent);
        ResultObj resultObj = new ResultObj(addUrgent,addUrgent!=null?"success":"插入失败，出现未知的失败原因");
        return resultObj;
    }

    @RequestMapping(value = "/list",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj getUrgentPage(@RequestBody UrgentPageableVo urgentPageableVo){
        return new ResultObj(urgentService.getPage(urgentPageableVo.getUrgent(), urgentPageableVo.getPageable()),"success");
    }

    @RequestMapping(method = RequestMethod.DELETE)
    public ResultObj delUrgent(@NotNull Long urgentId){
        return new ResultObj(urgentService.delete(urgentId),"success");
    }

    @RequestMapping(method = RequestMethod.GET)
    public ResultObj getUrgent(@NotNull Long urgentId){
        return new ResultObj(urgentService.getOne(urgentId),"success");
    }

    @RequestMapping(method = RequestMethod.PUT,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj updateUrgent(@Validated(GroupUpdate.class) @RequestBody Urgent urgent){
        return new ResultObj(urgentService.update(urgent),"success");
    }
}
