package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.WorkExperience;
import com.example.personnelmanager.entity.commonEntity.ResultObj;
import com.example.personnelmanager.entity.vo.pageableVo.WorkExperiencePageableVo;
import com.example.personnelmanager.service.WorkExperienceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class WorkExperienceController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/28
 **/
@RestController
@RequestMapping("/api/workExperience")
public class WorkExperienceController {

    @Autowired
    WorkExperienceService workExperienceService;

    @RequestMapping(method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj addWorkExperience(@Validated(GroupSave.class) @RequestBody WorkExperience workExperience){
        WorkExperience addWorkExperience = workExperienceService.addEntity(workExperience);
        return new ResultObj(addWorkExperience,addWorkExperience!=null?"success":"插入失败，出现未知的失败原因");
    }

    @RequestMapping(value = "/list",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj getWorkExperiencePage(@RequestBody WorkExperiencePageableVo workExperiencePageableVo){
        return new ResultObj(workExperienceService.getPage(workExperiencePageableVo.getWorkExperience(), workExperiencePageableVo.getPageable()),"success");
    }

    @RequestMapping(method = RequestMethod.DELETE)
    public ResultObj delUrgent(@NotNull Long workExperienceId){
        return new ResultObj(workExperienceService.delete(workExperienceId),"success");
    }

    @RequestMapping(method = RequestMethod.GET)
    public ResultObj getUrgent(@NotNull Long workExperienceId){
        return new ResultObj(workExperienceService.getOne(workExperienceId),"success");
    }

    @RequestMapping(method = RequestMethod.PUT,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj updateUrgent(@Validated(GroupUpdate.class) @RequestBody WorkExperience workExperience){
        return new ResultObj(workExperienceService.update(workExperience),"success");
    }
}
