package com.example.personnelmanager.service.impl;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.DateCenterJsonUtil;
import com.example.personnelmanager.common.utils.HttpClientUtil;
import com.example.personnelmanager.dao.PeoplePostRepository;
import com.example.personnelmanager.dao.PeopleRepository;
import com.example.personnelmanager.entity.*;
import com.example.personnelmanager.entity.commonEntity.CustomPage;
import com.example.personnelmanager.service.JobTransferInformationService;
import com.example.personnelmanager.service.PeoplePostService;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.parameters.P;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class PeoplePostServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/21
 **/


@Service
public class PeoplePostServiceImpl implements PeoplePostService {

    @Autowired
    DateCenterJsonUtil dateCenterJsonUtil;

    @Autowired
    HttpClientUtil httpClientUtil;

    @Autowired
    ExecutorService executorService;

    final PeoplePostRepository peoplePostRepository;

    @Autowired
    PeopleRepository peopleRepository;

    final JobTransferInformationService jobTransferInformationService;

    public PeoplePostServiceImpl(PeoplePostRepository peoplePostRepository, JobTransferInformationService jobTransferInformationService) {
        this.peoplePostRepository = peoplePostRepository;
        this.jobTransferInformationService = jobTransferInformationService;
    }

    @Override
    public PeoplePost addEntity(PeoplePost peoplePost) {
        //查询用的
        PeoplePost psSelect = new PeoplePost();
        psSelect.setPeople(peoplePost.getPeople());
        Page list = getPage(psSelect, new CustomPage().getPageable());
        if (list.getContent().size()>0){
            //该位置由一对多变成了一对一   由于前端时间有限   本项目没有设置VO 先不改
            throw new GlobalException("该人员已经有岗位上");
        }
        PeoplePost save = peoplePostRepository.save(peoplePost);
        executorService.submit(() -> {
            httpClientUtil.put("http://124.70.194.194:8090/opt/data", dateCenterJsonUtil.initAllPeopleJsonStr(Arrays.asList(peopleRepository.getOne(save.getPeople().getPeopleId()))), "utf-8");
        });
        return save;
    }

    @Override
    public Page getPage(PeoplePost peoplePost, Pageable pageable) {
        Specification<PeoplePost> specification = specificationBuild(peoplePost);
        return (Page<PeoplePost>) peoplePostRepository.findAll(specification, pageable);
    }

    @Override
    public List<PeoplePost> getList(PeoplePost peoplePost) {
        Specification<PeoplePost> specification = specificationBuild(peoplePost);
        return peoplePostRepository.findAll(specification);
    }

    @Override
    public PeoplePost update(PeoplePost peoplePost) {
        PeoplePost save = peoplePostRepository.save(peoplePost);
        executorService.submit(() -> {
            httpClientUtil.put("http://124.70.194.194:8090/opt/data", dateCenterJsonUtil.initAllPeopleJsonStr(Arrays.asList(peopleRepository.getOne(save.getPeople().getPeopleId()))), "utf-8");
        });
        return save;

    }

    @Override
    public PeoplePost getOne(Long id) {
        Optional<PeoplePost> byId = peoplePostRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的人员不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        try {
            peoplePostRepository.deleteById(id);
        }catch (Exception e){
            return false;
        }
        return true;
    }

    @Override
    public Specification<PeoplePost> specificationBuild(PeoplePost peoplePost) {
        PredicateBuilder<PeoplePost> and = Specifications.and();
        if (peoplePost.getPeople()!=null){
            and.eq("people",peoplePost.getPeople().getPeopleId());
        }
        if (peoplePost.getPost()!=null){
            and.eq("post",peoplePost.getPost());
        }
        return and.build();
    }

}
