package com.example.personnelmanager.common.utils;

import com.example.personnelmanager.entity.UserDetail;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

/**
 * 描述：用户实体相关工具类
 *
 * @author HuangXiahao
 * @version V1.0
 * @class AuthenticationUtils
 * @packageName com.example.personnelmanager.common.utils
 * @data 2020/5/14
 **/
public class AuthenticationUtils {

    //获取当前登录用户
    public static UserDetail getAuthentication(){
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication.getPrincipal().equals("anonymousUser")){
            throw new UsernameNotFoundException("当前无登录用户");
        }
        return (UserDetail) authentication.getPrincipal();
    }

}
