package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupSaveImage;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.Certificate;
import com.example.personnelmanager.entity.CertificateImage;
import com.example.personnelmanager.entity.commnEntity.ResultObj;
import com.example.personnelmanager.entity.vo.CertificateVo;
import com.example.personnelmanager.service.CertificateImageService;
import com.example.personnelmanager.service.CertificateService;
import org.springframework.http.MediaType;
import org.springframework.util.ClassUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.NotNull;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class CertificateController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/18
 **/
@RestController
@RequestMapping("/api/certificate")
public class CertificateController {

    final CertificateService certificateService;

    final CertificateImageService certificateImageService;

    public CertificateController(CertificateService certificateService, CertificateImageService certificateImageService) {
        this.certificateService = certificateService;
        this.certificateImageService = certificateImageService;
    }

    /**
     * 描述：新增证书
     * @param certificate
     * @return ResultObj<Certificate>
     */
    @RequestMapping(method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj addCertificate(@Validated(GroupSave.class) @RequestBody Certificate certificate) {
        Certificate addCertificate = certificateService.addEntity(certificate);
        return new ResultObj(addCertificate, addCertificate != null ? "success" : "插入失败，出现未知的失败原因");
    }


    @RequestMapping(value = "/list",method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj getCertificatePage(@RequestBody CertificateVo certificateVo) {
        return new ResultObj(certificateService.getList(certificateVo.getCertificate(), certificateVo.getPageable()), "success");
    }

    @RequestMapping(method = RequestMethod.DELETE)
    public ResultObj delCertificate(@NotNull Long certificateId) {
        return new ResultObj(certificateService.delete(certificateId), "success");
    }

    @RequestMapping(method = RequestMethod.GET)
    public ResultObj getContract(@NotNull Long certificateId) {
        return new ResultObj(certificateService.getOne(certificateId), "success");
    }

    @RequestMapping(method = RequestMethod.PUT, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj updateContract(@Validated(GroupUpdate.class) @RequestBody Certificate certificate) {
        return new ResultObj(certificateService.update(certificate), "success");
    }

    @RequestMapping(value = "/deleteImage",method = RequestMethod.DELETE)
    public ResultObj delContractImage(@NotNull Long certificateImageId) {
        return new ResultObj(certificateImageService.delete(certificateImageId), "success");
    }

    @RequestMapping(value = "/file",method = RequestMethod.POST)
    public ResultObj addContractImage(@RequestParam("file") MultipartFile file, @Validated(GroupSaveImage.class) Long certificateId) throws IOException {
        if (!file.isEmpty()) {
            CertificateImage certificateImage = new CertificateImage();
            //获取文件名
            String fileName = file.getOriginalFilename();
            //获取文件后缀
            String suffixName = fileName.substring(fileName.lastIndexOf("."));
            //重新生成文件名
            fileName = UUID.randomUUID() + suffixName;
            //指定本地存入路径
            String path = Objects.requireNonNull(ClassUtils.getDefaultClassLoader()).getResource("static/images/").getPath();
            file.transferTo(new File(path + fileName));
            Certificate certificate = new Certificate();
            certificate.setCertificateId(certificateId);
            certificateImage.setCertificate(certificate);
            certificateImage.setUrl("/images/" + fileName);
            certificateImageService.addEntity(certificateImage);
            return new ResultObj(certificateImage, "success");
        } else {
            throw new GlobalException("文件是空的");
        }
    }

}
