package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.validIGroup.GroupDelete;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.OrganizationNode;
import com.example.personnelmanager.entity.commnEntity.ResultObj;
import com.example.personnelmanager.entity.vo.OrganizationNodeListVo;
import com.example.personnelmanager.service.OrganizationNodeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class OrganizationNodeController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/15
 **/
@RestController
@RequestMapping(value = "/api/organizationNode")
public class OrganizationNodeController {

    @Autowired
    OrganizationNodeService organizationNodeService;

    @RequestMapping(method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj<OrganizationNode> addOrganizationNode(@Validated(GroupSave.class) @RequestBody OrganizationNode organizationNode){
        OrganizationNode addNode = organizationNodeService.addEntity(organizationNode);
        ResultObj<OrganizationNode> resultObj = new ResultObj(addNode,addNode!=null?"success":"插入失败，出现未知的失败原因");
        return resultObj;
    }

    @RequestMapping(value = "/getTree",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj<List<OrganizationNodeListVo>> getOrganizationNodeTree(){
        List<OrganizationNodeListVo> addNode = organizationNodeService.getTree();
        ResultObj<List<OrganizationNodeListVo>> resultObj = new ResultObj(addNode,addNode!=null?"success":"插入失败，出现未知的失败原因");
        return resultObj;
    }

    @RequestMapping(method = RequestMethod.GET)
    public ResultObj getOrganizationNode(@NotNull Long nodeId){
        return new ResultObj(organizationNodeService.getOne(nodeId),"success");
    }

    @RequestMapping(method = RequestMethod.DELETE)
    public ResultObj delOrganizationNode(@NotNull Long nodeId) {
        return new ResultObj(organizationNodeService.delete(nodeId), "success");
    }

    @RequestMapping(method = RequestMethod.PUT, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj updateOrganizationNode(@Validated(GroupUpdate.class) @RequestBody OrganizationNode organizationNode) {
        return new ResultObj(organizationNodeService.update(organizationNode), "success");
    }
}
