package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupSaveImage;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.*;
import com.example.personnelmanager.entity.commnEntity.ResultObj;
import com.example.personnelmanager.entity.vo.PeopleVo;
import com.example.personnelmanager.service.PeopleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.NotNull;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class PeopleController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/15
 **/
@RestController
@RequestMapping("/api/people")
public class PeopleController {

    @Autowired
    PeopleService peopleService;

    @RequestMapping(method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj<People> addPeople(@Validated(GroupSave.class) @RequestBody People people){
        People addPeople = peopleService.addEntity(people);
        ResultObj<People> resultObj = new ResultObj(addPeople,addPeople!=null?"success":"插入失败，出现未知的失败原因");
        return resultObj;
    }

    @RequestMapping(value = "/list",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj getPeoplePage(@RequestBody PeopleVo peopleDto){
        return new ResultObj(peopleService.getList(peopleDto),"success");
    }

    @RequestMapping(method = RequestMethod.DELETE)
    public ResultObj delPeople(@NotNull Long peopleId){
        return new ResultObj(peopleService.delete(peopleId),"success");
    }

    @RequestMapping(method = RequestMethod.GET)
    public ResultObj getPeople(@NotNull Long peopleId){
        return new ResultObj(peopleService.getOne(peopleId),"success");
    }

    @RequestMapping(method = RequestMethod.PUT,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj updatePeople(@Validated(GroupUpdate.class) @RequestBody People people){
        return new ResultObj(peopleService.update(people),"success");
    }

    @RequestMapping(value = "/leave",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj<People> leave(@Validated(GroupSave.class) @RequestBody LeaveInformation leaveInformation){
        People leave = peopleService.leave(leaveInformation);
        ResultObj<People> resultObj = new ResultObj(leave,"success");
        return resultObj;
    }

    @RequestMapping(value = "/againEntry",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj<People> againEntry(@Validated(GroupSave.class) @RequestBody AgainEntryInformation againEntryInformation){
        People leave = peopleService.againEntry(againEntryInformation);
        ResultObj<People> resultObj = new ResultObj(leave,"success");
        return resultObj;
    }

    @RequestMapping(value = "/becomeRegularWorker",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj<People> becomeRegularWorker(@Validated(GroupSave.class) @RequestBody BecomeRegularWorkerInformation becomeRegularWorkerInformation){
        People leave = peopleService.becomeRegularWorker(becomeRegularWorkerInformation);
        ResultObj<People> resultObj = new ResultObj(leave,"success");
        return resultObj;
    }

    @RequestMapping(value = "/file",method = RequestMethod.POST)
    public People addContractImage(@RequestParam("file") MultipartFile file, @Validated(GroupSaveImage.class) Long peopleId,String type) throws IOException {
        if (!file.isEmpty()) {
            //获取文件名
            String fileName = file.getOriginalFilename();
            //获取文件后缀
            String suffixName = fileName.substring(fileName.lastIndexOf("."));
            //重新生成文件名
            fileName = UUID.randomUUID() + suffixName;
            //指定本地存入路径
            String path = ClassUtils.getDefaultClassLoader().getResource("static/images/").getPath();
            file.transferTo(new File(path + fileName));
            if (!StringUtils.isEmpty(type)){
                People one = peopleService.getOne(peopleId);
                if (type.equals("front")){
                    one.setIdCardFrontUrl("/images/" + fileName);
                }else if (type.equals("back")){
                    one.setIdCardBackUrl("/images/"+fileName);
                }else {
                    throw new GlobalException("请输入证件照片属于哪一面");
                }
                peopleService.update(one);
                return one;
            }else {
                throw new GlobalException("请输入证件照片属于哪一面");
            }
        } else {
            throw new GlobalException("文件是空的");
        }
    }

}
