package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.Title;
import com.example.personnelmanager.entity.TitleImage;
import com.example.personnelmanager.entity.commnEntity.ResultObj;
import com.example.personnelmanager.entity.vo.TitleVo;
import com.example.personnelmanager.service.TitleImageService;
import com.example.personnelmanager.service.TitleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.ClassUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.NotNull;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class TitleController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/18
 **/

@RestController
@RequestMapping("/api/title")
public class TitleController {

    @Autowired
    TitleService titleService;

    @Autowired
    TitleImageService titleImageService;

    @RequestMapping(method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj<Title> addTitle(@Validated(GroupSave.class) @RequestBody Title title) {
        Title addTitle = titleService.addEntity(title);
        return (ResultObj<Title>) new ResultObj(addTitle, addTitle != null ? "success" : "插入失败，出现未知的失败原因");
    }

    @RequestMapping(value = "/list",method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj getTitlePage(@RequestBody TitleVo titleVo) {
        return new ResultObj(titleService.getList(titleVo.getTitle(), titleVo.getPageable()), "success");
    }

    @RequestMapping(method = RequestMethod.DELETE)
    public ResultObj delContract(@NotNull Long titleId) {
        return new ResultObj(titleService.delete(titleId), "success");
    }

    @RequestMapping(method = RequestMethod.GET)
    public ResultObj getTitle(@NotNull Long titleId) {
        return new ResultObj(titleService.getOne(titleId), "success");
    }

    @RequestMapping(method = RequestMethod.PUT, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj updateTitle(@Validated(GroupUpdate.class) @RequestBody Title title) {
        return new ResultObj(titleService.update(title), "success");
    }

    @RequestMapping(value = "/deleteImage",method = RequestMethod.DELETE)
    public ResultObj delTitleImage(@NotNull Long titleImageId) {
        return new ResultObj(titleImageService.delete(titleImageId), "success");
    }

    @RequestMapping(value = "/file",method = RequestMethod.POST)
    public ResultObj<Title> addTitleImage(@RequestParam("file") MultipartFile file, @NotNull Long titleId) throws IOException {
        if (!file.isEmpty()) {
            TitleImage titleImage = new TitleImage();
            //获取文件名
            String fileName = file.getOriginalFilename();
            //获取文件后缀
            String suffixName = fileName.substring(fileName.lastIndexOf("."));
            //重新生成文件名
            fileName = UUID.randomUUID() + suffixName;
            //指定本地存入路径
            String path = ClassUtils.getDefaultClassLoader().getResource("static/images/").getPath();
            file.transferTo(new File(path + fileName));
            Title title = new Title();
            title.setTitleId(titleId);
            titleImage.setTitle(title);
            titleImage.setUrl("/images/" + fileName);
            titleImageService.addEntity(titleImage);
            return new ResultObj(titleImageService, "success");
        } else {
            throw new GlobalException("文件是空的");
        }
    }
}
