package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.entity.LegalEntity;
import com.example.personnelmanager.entity.User;
import com.example.personnelmanager.entity.commnEntity.ResultObj;
import com.example.personnelmanager.service.UserServer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class UserController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/14
 **/
@RestController
@RequestMapping("/api/user")
public class UserController {

    @Autowired
    UserServer userServer;

    @RequestMapping(method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
        public ResultObj<LegalEntity> addUser(@Validated(GroupSave.class) @RequestBody User user){
        User addUser = userServer.addEntity(user);
        return (ResultObj<LegalEntity>) new ResultObj(addUser,addUser!=null?"success":"插入失败，出现未知的失败原因");
    }

}
