package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.validIGroup.GroupDelete;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.LegalEntity;
import com.example.personnelmanager.entity.WorkPlace;
import com.example.personnelmanager.entity.commnEntity.ResultObj;
import com.example.personnelmanager.entity.vo.WorkPlaceVo;
import com.example.personnelmanager.entity.vo.WorkPlacePageableVo;
import com.example.personnelmanager.service.WorkPlaceService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class WorkPlaceController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/14
 **/
@RestController
@RequestMapping("/api/workPlace")
public class WorkPlaceController {

    @Autowired
    WorkPlaceService workPlaceService;

    @RequestMapping(method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj<LegalEntity> addLWorkPlace(@Validated(GroupSave.class) @RequestBody WorkPlaceVo workPlaceDto){
        WorkPlace workPlace = new WorkPlace();
        BeanUtils.copyProperties(workPlaceDto,workPlace);
        WorkPlace addWork = workPlaceService.addEntity(workPlace);
        return (ResultObj<LegalEntity>) new ResultObj(addWork,addWork!=null?"success":"插入失败，出现未知的失败原因");
    }

    @RequestMapping(value = "/list",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj getWorkPlacePage(@RequestBody WorkPlacePageableVo workPlaceVo){
        return new ResultObj(workPlaceService.getList(workPlaceVo.getWorkPlace(),workPlaceVo.getPageable()),"success");
    }

    @RequestMapping(method = RequestMethod.DELETE)
    public ResultObj delWorkPlace(@NotNull  Long workPlaceId){
        return new ResultObj(workPlaceService.delete(workPlaceId),"success");
    }

    @RequestMapping(method = RequestMethod.GET)
    public ResultObj getWorkPlace(@NotNull Long workPlaceId){
        return new ResultObj(workPlaceService.getOne(workPlaceId),"success");
    }

    @RequestMapping(method = RequestMethod.PUT,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj updateWorkPlace(@Validated(GroupUpdate.class) @RequestBody WorkPlaceVo workPlaceDto){
        WorkPlace workPlace = new WorkPlace();
        BeanUtils.copyProperties(workPlaceDto,workPlace);
        return new ResultObj(workPlaceService.update(workPlace),"success");
    }
}
