package com.example.personnelmanager.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.time.Instant;
import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class AgainEntryInformation
 * @packageName com.example.personnelmanager.entity
 * @data 2020/5/29
 **/
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "again_entry_information")
@ToString(exclude = {"people"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class AgainEntryInformation {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "again_entry_id"  ,columnDefinition = "bigint comment '再入职记录编号'")
    private Long againEntryId;

    @Column(name = "again_entry_time" ,nullable = false, columnDefinition = "datetime comment '再入职时间'")
    private Instant againEntryTime;

    @Lob
    @Column(name = "remarks",columnDefinition = "text comment '备注' ")
    private String remarks;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH},optional = false)
    @JoinColumn(name = "people_id",columnDefinition = "bigint not null comment '人员编号'")
    private People people;

    @Column(name = "create_time",nullable = false,columnDefinition = "datetime default CURRENT_TIMESTAMP comment '创建时间' ")
    private Instant createTime;

    @Column(name = "delete_tag" ,nullable = false, columnDefinition = "int default 0 comment '删除标记'")
    private int deleteTag;
}
