package com.example.personnelmanager.entity;


import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.Instant;
import java.util.List;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "certificate")
@ToString(exclude = {"people","enterprise"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class Certificate {

  @NotNull(groups = {GroupUpdate.class},message = "编辑时编号不能为空")
  @Null(groups = {GroupSave.class},message = "新增时不能传入编号")
  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "certificate_id"  ,columnDefinition = "bigint comment '合同编号'")
  private Long certificateId;

  @Column(name = "certificate_name" ,columnDefinition = "varchar(64) comment '证书名称'")
  private String certificateName;

  @Column(name = "certificate_obtain_time" , columnDefinition = "datetime comment '证书获得时间'")
  private Instant certificateObtainTime;

  @Column(name = "delete_tag",nullable = false,columnDefinition = "int default 0 comment '删除标记（0为正常，1为被删除）'")
  private int deleteTag;

  @Column(name = "licensing_organization",columnDefinition = "varchar(64) comment '发证机关'")
  private String licensingOrganization;

  @Column(name = "create_time",nullable = false,columnDefinition = "datetime default CURRENT_TIMESTAMP comment '创建时间' ")
  private Instant createTime;

  @Where(clause = "delete_tag = 0")
  @OneToMany(cascade = CascadeType.REFRESH,mappedBy = "certificate")
  List<CertificateImage> certificateImages;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH},optional = false)
  @JoinColumn(name = "people_id",columnDefinition = "bigint not null comment '人员编号'")
  private People people;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH},optional=false)
  @JoinColumn(name = "enterprise_id",columnDefinition = "bigint comment '所属企业'")
  private Enterprise enterprise;

}
