package com.example.personnelmanager.entity;

import com.example.personnelmanager.common.validIGroup.*;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.time.Instant;
import java.util.List;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "contract")
@ToString(exclude = {"people","enterprise"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class Contract {

  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "contract_id" ,columnDefinition = "bigint comment '合同编号' ")
  @Min(value = 0,groups = {GroupSaveImage.class, GroupUpdate.class, GroupGetOne.class, GroupDelete.class},message = "此操作需要只能一个对象")
  private Long contractId;

  @Column(name = "contract_company" , columnDefinition = "varchar(128) comment '合同公司' ")
  private String contractCompany;

  @Column(name = "contract_type" , columnDefinition = "varchar(16) comment '合同类型(劳务合同、劳动合同、实习合同、雇佣合同、其他)'")
  private String contractType;

  @NotNull(message = "合同开始时间不能为空",groups = {GroupSave.class})
  @Column(name = "contract_start_time" , columnDefinition = " datetime comment '合同开始时间' ")
  private Instant contractStartTime;

  @NotNull(message = "合同结束时间不能为空",groups = {GroupSave.class})
  @Column(name = "contract_end_time" , columnDefinition = " datetime comment '合同结束时间' ")
  private Instant contractEndTime;

  @Column(name = "contract_sign_time" , columnDefinition = " datetime comment '合同签订时间'")
  private Instant contractSignTime;

  @Lob
  @Column(name = "remark", columnDefinition = "text comment '备注'")
  private String remark;

  @Column(name = "delete_tag" ,nullable = false, columnDefinition = "int default 0 comment '删除标记'")
  private int deleteTag;

  @Column(name = "create_time" ,nullable = false, columnDefinition = "datetime default CURRENT_TIMESTAMP comment '删除标记（0为正常，1为被删除）'")
  private Instant createTime;

  @Where(clause = "delete_tag = 0")
  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH,mappedBy = "contract")
  private List<ContractImage> contractImages;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH},optional = false)
  @JoinColumn(name = "people_id",columnDefinition = "bigint not null comment '人员编号'")
  private People people;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH},optional=false)
  @JoinColumn(name = "enterprise_id",columnDefinition = "bigint comment '所属企业'")
  private Enterprise enterprise;
}
