package com.example.personnelmanager.entity;

import com.example.personnelmanager.common.validIGroup.GroupDelete;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class PeoplePost
 * @packageName com.example.personnelmanager.entity
 * @data 2020/5/14
 **/
@Entity
@DynamicUpdate
@DynamicInsert
@Table(name = "people_post")
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
@ToString(exclude = {"post"})
@Data
public class PeoplePost implements Serializable {

    private static final long serialVersionUID = 1207408282047173539L;

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id"  ,columnDefinition = "bigint comment '编号'")
    @Min(value = 1,groups = {GroupDelete.class,GroupUpdate.class})
    private Long id;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @NotNull(groups = {GroupSave.class})
    @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH},optional=false)
    @JoinColumn(name="people_id")
    private People people;

    @NotNull(groups = {GroupSave.class})
    @JsonIgnoreProperties(value = {"enterprise"})
    @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH},optional=false)
    @JoinColumn(name="post_id")
    private Post post;


}
