package com.example.personnelmanager.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.time.Instant;
import java.util.List;

@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "title")
@ToString(exclude = {"people","enterprise"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
public class Title {

  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "title_id",columnDefinition = "bigint comment '职称编号'")
  private Long titleId;

  @Column(name = "title_level",nullable = false,columnDefinition = "varchar(16) comment '职称等级具有以下几种：员级、助理级、中级、副高级、正高'")
  private String titleLevel;

  @Column(name = "title_type",columnDefinition = "varchar(32) comment '职称类型具有以下几种：高等学校教师、中等专业学校教师、技工学校教师、中学教师、小学教师、幼儿园教师、自然科学研究人员、社会科学研究人员、工程技术人员、实验技术人员、农业技术人员、卫生技术人员、经济专业人员、会计专业人员、审计专业人员、统计专业人员、新闻专业人员、出版专业人员、图书资料专业人员、文物博物专业人员、档案专业人员、广播电视播音人员、翻译人员、律师、公证员、海关人员、船舶技术人员、民用航空飞行技术人员、艺术专业人员、工艺美术专业人员、体育教练员、思想政治工作人员'")
  private String titleType;

  @Column(name = "title_name",nullable = false,columnDefinition = "varchar(64) comment '职称名称'")
  private String titleName;

  @Column(name = "title_obtain_date",columnDefinition = "datetime comment '职称证书获得时间'")
  private Instant titleObtainDate;

  @Where(clause = "delete_tag = 0")
  @Column(name = "deleteTag",nullable = false,columnDefinition = "int default 0 comment '删除标记（0为正常，1为被删除）' ")
  private int deleteTag;

  @Column(name = "create_time",nullable = false,columnDefinition = "datetime default CURRENT_TIMESTAMP comment '创建时间' ")
  private Instant createTime;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH})
  @JoinColumn(name = "people_id",columnDefinition = "bigint comment '所属人员'")
  private People people;

  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @ManyToOne(fetch = FetchType.LAZY,cascade={CascadeType.MERGE,CascadeType.REFRESH},optional=false)
  @JoinColumn(name = "enterprise_id",columnDefinition = "bigint comment '所属企业'")
  private Enterprise enterprise;

  @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH,mappedBy = "title")
  private List<TitleImage> titleImages ;

}
