package com.example.personnelmanager.service;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.dao.AgainEntryInformationRepository;
import com.example.personnelmanager.entity.AgainEntryInformation;
import com.example.personnelmanager.entity.CertificateImage;
import com.example.personnelmanager.entity.LeaveInformation;
import com.example.personnelmanager.entity.People;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class AgainEntryInformationServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/29
 **/
@Service
public class AgainEntryInformationServiceImpl implements AgainEntryInformationService{

    @Autowired
    AgainEntryInformationRepository againEntryInformationRepository;

    @Override
    public AgainEntryInformation addEntity(AgainEntryInformation againEntryInformation) {
        AgainEntryInformation save = againEntryInformationRepository.save(againEntryInformation);
        return save;
    }

    @Override
    public Page getList(AgainEntryInformation againEntryInformation, Pageable pageable) {
        PredicateBuilder and = Specifications.and();
        and.eq("deleteTag", 0);
        Specification<AgainEntryInformation> specification = and.build();
        Page<AgainEntryInformation> all = againEntryInformationRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    public AgainEntryInformation update(AgainEntryInformation againEntryInformation) {
        AgainEntryInformation after = againEntryInformationRepository.save(againEntryInformation);
        return after;
    }

    @Override
    public AgainEntryInformation getOne(Long id) {
        Optional<AgainEntryInformation> byId = againEntryInformationRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的再入职记录不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<AgainEntryInformation> byId = againEntryInformationRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的再入职记录");
        }
        AgainEntryInformation againEntryInformation = byId.get();
        againEntryInformation.setDeleteTag(1);
        againEntryInformationRepository.save(againEntryInformation);
        return true;
    }
}
