package com.example.personnelmanager.service;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.dao.BecomeRegularWorkerRepository;
import com.example.personnelmanager.entity.AgainEntryInformation;
import com.example.personnelmanager.entity.BecomeRegularWorkerInformation;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.*;
import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class BecomeRegularWorkerServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/29
 **/
@Service
public class BecomeRegularWorkerServiceImpl implements BecomeRegularWorkerService {

    @Autowired
    BecomeRegularWorkerRepository becomeRegularWorkerRepository;

    @Override
    public BecomeRegularWorkerInformation addEntity(BecomeRegularWorkerInformation becomeRegularWorkerInformation) {
        BecomeRegularWorkerInformation save = becomeRegularWorkerRepository.save(becomeRegularWorkerInformation);
        return save;
    }

    @Override
    public Page getList(BecomeRegularWorkerInformation becomeRegularWorkerInformation, Pageable pageable) {
        PredicateBuilder and = Specifications.and();
        and.eq("deleteTag", 0);
        Specification<AgainEntryInformation> specification = and.build();
        Page<AgainEntryInformation> all = becomeRegularWorkerRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    public BecomeRegularWorkerInformation update(BecomeRegularWorkerInformation becomeRegularWorkerInformation) {
        BecomeRegularWorkerInformation after = becomeRegularWorkerRepository.save(becomeRegularWorkerInformation);
        return after;
    }

    @Override
    public BecomeRegularWorkerInformation getOne(Long id) {
        Optional<BecomeRegularWorkerInformation> byId = becomeRegularWorkerRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的转正记录不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<BecomeRegularWorkerInformation> byId = becomeRegularWorkerRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的转正记录记录");
        }
        BecomeRegularWorkerInformation becomeRegularWorkerInformation = byId.get();
        becomeRegularWorkerInformation.setDeleteTag(1);
        becomeRegularWorkerRepository.save(becomeRegularWorkerInformation);
        return true;
    }
}
