package com.example.personnelmanager.service;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.dao.CertificateImageRepository;
import com.example.personnelmanager.entity.Certificate;
import com.example.personnelmanager.entity.CertificateImage;
import com.example.personnelmanager.entity.ContractImage;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import java.util.Optional;

@Service
public class CertificateImageServiceImpl implements CertificateImageService {

    @Autowired
    CertificateImageRepository certificateImageRepository;

    @Override
    public CertificateImage addEntity(CertificateImage certificateImage) {
        CertificateImage save = certificateImageRepository.save(certificateImage);
        return save;
    }

    @Override
    public Page getList(CertificateImage certificateImage, Pageable pageable) {
        PredicateBuilder and = Specifications.<CertificateImage>and();
        and.eq("certificate",certificateImage.getCertificate().getCertificateId());
        and.eq("deleteTag", 0);
        Specification<CertificateImage> specification = and.build();
        Page<CertificateImage> all = certificateImageRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    public CertificateImage update(CertificateImage certificateImage) {
        return null;
    }

    @Override
    public CertificateImage getOne(Long id) {
        Optional<CertificateImage> byId = certificateImageRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的合同不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<CertificateImage> byId = certificateImageRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的合同照片");
        }
        CertificateImage certificateImage = byId.get();
        certificateImage.setDeleteTag(1);
        certificateImageRepository.save(certificateImage);
        return true;
    }
}
