package com.example.personnelmanager.service;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.dao.ContractImageRepository;
import com.example.personnelmanager.entity.Certificate;
import com.example.personnelmanager.entity.ContractImage;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class ContractImageServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/15
 **/
@Service
public class ContractImageServiceImpl implements ContractImageService {

    @Autowired
    ContractImageRepository contractImageRepository;


    @Override
    public ContractImage addEntity(ContractImage ContractImage) {
        ContractImage save = contractImageRepository.save(ContractImage);
        return save;
    }

    @Override
    public Page getList(ContractImage contractImage, Pageable pageable) {
        PredicateBuilder and = Specifications.<ContractImage>and();
        and.eq("contract",contractImage.getContract().getContractId());
        and.eq("deleteTag", 0);
        Specification<ContractImage> specification = and.build();
        Page<ContractImage> all = contractImageRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    public ContractImage update(ContractImage contractImage) {
        return null;
    }

    @Override
    public ContractImage getOne(Long id) {
        Optional<ContractImage> byId = contractImageRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的合同不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<ContractImage> byId = contractImageRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的合同照片");
        }
        ContractImage contractImage = byId.get();
        contractImage.setDeleteTag(1);
        contractImageRepository.save(contractImage);
        return true;
    }
}
