package com.example.personnelmanager.service;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.dao.LeaveInformationRepository;
import com.example.personnelmanager.entity.LeaveInformation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class LeaveInformationServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/28
 **/
@Service
public class LeaveInformationServiceImpl implements LeaveInformationService{

    @Autowired
    LeaveInformationRepository leaveInformationRepository;

    @Override
    public LeaveInformation addEntity(LeaveInformation leaveInformation) {
        LeaveInformation save = leaveInformationRepository.save(leaveInformation);
        return save;
    }

    @Override
    public Page getList(LeaveInformation leaveInformation, Pageable pageable) {
        return null;
    }

    @Override
    public LeaveInformation update(LeaveInformation leaveInformation) {
        LeaveInformation after = leaveInformationRepository.save(leaveInformation);
        return after;
    }

    @Override
    public LeaveInformation getOne(Long id) {
        Optional<LeaveInformation> byId = leaveInformationRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的离职记录不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<LeaveInformation> byId = leaveInformationRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的教育经历照片");
        }
        LeaveInformation leaveInformation = byId.get();
        leaveInformation.setDeleteTag(1);
        leaveInformationRepository.save(leaveInformation);
        return true;
    }
}
