package com.example.personnelmanager.service;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.dao.LegalEntityRepository;
import com.example.personnelmanager.entity.LegalEntity;
import com.example.personnelmanager.entity.UserDetail;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.*;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class LegalEntityServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/13
 **/

@Service
public class LegalEntityServiceImpl implements LegalEntityService {

    @Autowired
    LegalEntityRepository legalEntityRepository;

    @Override
    public LegalEntity addEntity(LegalEntity legalEntity) {
        UserDetail userDetails =  AuthenticationUtils.getAuthentication();
        legalEntity.setEnterprise(userDetails.getEnterprise());
        LegalEntity save = legalEntityRepository.save(legalEntity);
        return save;
    }

    @Override
    public Page getList(LegalEntity legalEntity, Pageable pageable) {
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        PredicateBuilder<LegalEntity> and = Specifications.and();
        if (legalEntity!=null){
            if (!StringUtils.isEmpty(legalEntity.getLegalEntityName())){
                and.like("legalEntityName","%"+legalEntity.getLegalEntityName()+"%");
            }
            if (!StringUtils.isEmpty(legalEntity.getSocialCreditCode())){
                and.like("socialCreditCode","%"+legalEntity.getSocialCreditCode()+"%");
            }
            if (!StringUtils.isEmpty(legalEntity.getBank())){
                and.like("bank","%"+legalEntity.getBank()+"%");
            }
            if (!StringUtils.isEmpty(legalEntity.getTaxDeclarationArea())){
                and.like("taxDeclarationArea","%"+legalEntity.getTaxDeclarationArea()+"%");
            }
            if (!StringUtils.isEmpty(legalEntity.getAddress())){
                and.like("address","%"+legalEntity.getAddress()+"%");
            }
            if (!StringUtils.isEmpty(legalEntity.getPhone())){
                and.like("phone","%"+legalEntity.getPhone()+"%");
            }
        }
        and.eq("enterprise", userDetails.getEnterprise().getEnterpriseId());
        and.eq("deleteTag", 0);
        Specification<LegalEntity> specification = and.build();
        Page<LegalEntity> all = legalEntityRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    public LegalEntity update(LegalEntity legalEntity) {
        LegalEntity after = legalEntityRepository.save(legalEntity);
        return after;
    }

    @Override
    public LegalEntity getOne(Long id) {
        Optional<LegalEntity> byId = legalEntityRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的法律实体不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<LegalEntity> byId = legalEntityRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的法律实体");
        }
        LegalEntity legalEntity = byId.get();
        legalEntity.setDeleteTag(1);
        legalEntityRepository.save(legalEntity);
        return true;
    }

}
