package com.example.personnelmanager.service;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.dao.OrganizationNodeRepository;
import com.example.personnelmanager.dao.PostRepository;
import com.example.personnelmanager.entity.OrganizationNode;
import com.example.personnelmanager.entity.vo.OrganizationNodeListVo;
import com.example.personnelmanager.entity.UserDetail;
import com.example.personnelmanager.entity.vo.PostVo;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class OrganizationNodeServiceOmpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/15
 **/

@Service
@Transactional
public class OrganizationNodeServiceImpl implements OrganizationNodeService {

    @Autowired
    OrganizationNodeRepository organizationNodeRepository;

    @Autowired
    PostRepository postRepository;

    @Override
    public OrganizationNode addEntity(OrganizationNode organizationNode) {
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        if (organizationNode.getParentNode()!=null){
            OrganizationNode one = getOne(organizationNode.getParentNode());
            if (!one.getEnterprise().getEnterpriseId().equals(userDetails.getEnterprise().getEnterpriseId())){
                throw new UsernameNotFoundException("当前登录用户无权限操作该父节点");
            }
            organizationNode.setNodeLevel(one.getNodeLevel()+one.getNodeId()+".");
        }else {
            organizationNode.setNodeLevel("0.");
        }
        organizationNode.setEnterprise(userDetails.getEnterprise());
        OrganizationNode save = organizationNodeRepository.save(organizationNode);
        return save;
    }

    @Override
    public Page getList(OrganizationNode organizationNode, Pageable pageable) {
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        PredicateBuilder and = Specifications.<OrganizationNode>and();
        and.eq("enterprise", userDetails.getEnterprise().getEnterpriseId());
        and.eq("deleteTag", 0);
        Specification<OrganizationNode> specification = and.build();
        Page<OrganizationNode> all = organizationNodeRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    public List<OrganizationNodeListVo> getTree(){
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        List<PostVo> postResponseListVoList = postRepository.findPostTreeVo(userDetails.getEnterprise().getEnterpriseId());
        List<OrganizationNodeListVo> organizationNodeListVos = organizationNodeRepository.findTreeNode(userDetails.getEnterprise().getEnterpriseId());
        Map<Long, List<OrganizationNodeListVo>> nodeCollect =
                organizationNodeListVos.stream().collect(Collectors.groupingBy(OrganizationNodeListVo::getParentNode));

        List<OrganizationNodeListVo> result = nodeCollect.get(0L);
        getChild(organizationNodeListVos, nodeCollect);
        return result;
    }

    public void getChild(List<OrganizationNodeListVo> all, Map<Long, List<OrganizationNodeListVo>> nodeCollect){
        for (OrganizationNodeListVo parentNode: all) {
            List<OrganizationNodeListVo> childNodeList = nodeCollect.get(parentNode.getNodeId());
            parentNode.setChildeNodes(childNodeList);
            if (childNodeList!=null&&childNodeList.size()>0){
                getChild(childNodeList,nodeCollect);
            }
        }
    }



    @Override
    public OrganizationNode update(OrganizationNode organizationNode) {
        Optional<OrganizationNode> byId = organizationNodeRepository.findById(organizationNode.getNodeId());
        if (!byId.isPresent()) {
            throw new GlobalException("所要修改的节点不存在");
        }
        OrganizationNode one = byId.get();
        if (one.getParentNode()== 0L){
            if (organizationNode.getParentNode()!= 0L){
                throw new GlobalException("根节点不能被移动");
            }
        }
        OrganizationNode after = organizationNodeRepository.save(organizationNode);
        return after;
    }

    @Override
    public OrganizationNode getOne(Long id) {
        Optional<OrganizationNode> byId = organizationNodeRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的节点不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<OrganizationNode> byId = organizationNodeRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的节点");
        }
        OrganizationNode one = byId.get();
        if (one.getParentNode()== 0L){
            throw new GlobalException("根结点不能被删除");
        }
        //删除节点以及所有子节点
        organizationNodeRepository.deleteorganizationNode(id);
        //删除所有被删除节点下的岗位
        postRepository.deletePostByNodeId(id);
        return true;
    }
}
