package com.example.personnelmanager.service;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.dao.PeoplePostRepository;
import com.example.personnelmanager.entity.*;
import com.example.personnelmanager.entity.commnEntity.CustomPage;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.beans.Transient;
import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class PeoplePostServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/21
 **/


@Service
public class PeoplePostServiceImpl implements PeoplePostService {

    @Autowired
    PeoplePostRepository peoplePostRepository;

    @Autowired
    JobTransferInformationService jobTransferInformationService;
    
    @Override
    public PeoplePost addEntity(PeoplePost peoplePost) {
        Page list = getList(peoplePost, new CustomPage().getPageable());
        if (list.getContent().size()>0){
            throw new GlobalException("该人员已经在该岗位上");
        }
        PeoplePost save = peoplePostRepository.save(peoplePost);
        return save;
    }

    @Override
    public Page getList(PeoplePost peoplePost, Pageable pageable) {
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        PredicateBuilder and = Specifications.and();
        and.eq("people",peoplePost.getPeople().getPeopleId());
        and.eq("post",peoplePost.getPost().getPostId());
        Specification<Contract> specification = and.build();
        Page<PeoplePost> all = peoplePostRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    @Transactional
    public PeoplePost update(PeoplePost peoplePost) {
        PeoplePost save = peoplePostRepository.save(peoplePost);
        return save;
    }

    @Override
    public PeoplePost getOne(Long id) {
        Optional<PeoplePost> byId = peoplePostRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的人员不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        try {
            peoplePostRepository.deleteById(id);
        }catch (Exception e){
            return false;
        }
        return true;
    }

}
