package com.example.personnelmanager.service;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.dao.TitleImageRepository;
import com.example.personnelmanager.entity.*;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class TitleImageServiceImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/18
 **/
@Service
public class TitleImageServiceImpl implements TitleImageService {

    @Autowired
    TitleImageRepository titleImageRepository;


    @Override
    public TitleImage addEntity(TitleImage titleImage) {
        TitleImage save = titleImageRepository.save(titleImage);
        return save;
    }

    @Override
    public Page getList(TitleImage titleImage, Pageable pageable) {
        PredicateBuilder and = Specifications.<TitleImage>and();
        and.eq("title",titleImage.getTitle().getTitleId());
        and.eq("deleteTag", 0);
        Specification<TitleImage> specification = and.build();
        Page<TitleImage> all = titleImageRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    public TitleImage update(TitleImage titleImage) {
        TitleImage after = titleImageRepository.save(titleImage);
        return after;
    }

    @Override
    public TitleImage getOne(Long id) {
        Optional<TitleImage> byId = titleImageRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的职称图片不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<TitleImage> byId = titleImageRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的工作地点");
        }
        TitleImage titleImage = byId.get();
        titleImage.setDeleteTag(1);
        titleImageRepository.save(titleImage);
        return true;
    }

}
