package com.example.personnelmanager.service;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.dao.TitleRepository;
import com.example.personnelmanager.entity.Certificate;
import com.example.personnelmanager.entity.Title;
import com.example.personnelmanager.entity.UserDetail;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class TitleService
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/18
 **/

@Service
public class TitleServiceImpl implements TitleService{

    @Autowired
    TitleRepository titleRepository;

    @Override
    public Title addEntity(Title title) {
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        title.setEnterprise(userDetails.getEnterprise());
        Title save = titleRepository.save(title);
        return save;
    }

    @Override
    public Page getList(Title title, Pageable pageable) {
        UserDetail userDetails = AuthenticationUtils.getAuthentication();
        PredicateBuilder and = Specifications.and();
        and.eq("peopleId",title.getPeople().getPeopleId());
        and.eq("enterprise", userDetails.getEnterprise().getEnterpriseId());
        and.eq("deleteTag", 0);
        Specification<Certificate> specification = and.build();
        Page<Title> all = titleRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    public Title update(Title title) {
        Title after = titleRepository.save(title);
        return after;
    }

    @Override
    public Title getOne(Long id) {
        Optional<Title> byId = titleRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的职称信息不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<Title> byId = titleRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的工作地点");
        }
        Title title = byId.get();
        title.setDeleteTag(1);
        titleRepository.save(title);
        return true;
    }
}
