package com.example.personnelmanager.service;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.utils.AuthenticationUtils;
import com.example.personnelmanager.dao.UrgentRepository;
import com.example.personnelmanager.entity.Certificate;
import com.example.personnelmanager.entity.Title;
import com.example.personnelmanager.entity.Urgent;
import com.example.personnelmanager.entity.UserDetail;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.Optional;

@Service
public class UrgentServiceImpl implements UrgentService {

    @Autowired
    UrgentRepository urgentRepository;

    @Override
    public Urgent addEntity(Urgent urgent) {
        Urgent save = urgentRepository.save(urgent);
        return save;
    }

    @Override
    public Page getList(Urgent urgent, Pageable pageable) {
        PredicateBuilder and = Specifications.and();
        and.eq("peopleId",urgent.getPeople().getPeopleId());
        and.eq("deleteTag", 0);
        Specification<Urgent> specification = and.build();
        Page<Title> all = urgentRepository.findAll(specification, pageable);
        return all;
    }

    @Override
    public Urgent update(Urgent urgent) {
        Urgent after = urgentRepository.save(urgent);
        return after;
    }

    @Override
    public Urgent getOne(Long id) {
        Optional<Urgent> byId = urgentRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的紧急联系人信息不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<Urgent> byId = urgentRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的工作地点");
        }
        Urgent urgent = byId.get();
        urgent.setDeleteTag(1);
        urgentRepository.save(urgent);
        return true;
    }

}
