package com.example.personnelmanager.service;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.dao.UserRepository;
import com.example.personnelmanager.entity.User;
import com.example.personnelmanager.entity.UserDetail;
import com.example.personnelmanager.entity.WorkPlace;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class UserServerImpl
 * @packageName com.example.personnelmanager.service
 * @data 2020/5/14
 **/
@Service
public class UserServerImpl implements UserServer {

    @Autowired
    UserRepository userRepository;

    @Autowired
    PasswordEncoder passwordEncoder;

    @Override
    public User addEntity(User user) {
        user.setPassword(passwordEncoder.encode(user.getPassword()));
        User addUser = userRepository.save(user);
        return addUser;
    }

    @Override
    public Page getList(User user, Pageable pageable) {
        return null;
    }

    @Override
    public User update(User user) {
        User after = userRepository.save(user);
        return after;
    }

    @Override
    public User getOne(Long id) {
        Optional<User> byId = userRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("所要查询的工作地点不存在");
        }
        return byId.get();
    }

    @Override
    public Boolean delete(Long id) {
        Optional<User> byId = userRepository.findById(id);
        if (!byId.isPresent()) {
            throw new GlobalException("不存在需要被删除的工作地点");
        }
        User user = byId.get();
        user.setDeleteTag(1);
        userRepository.save(user);
        return true;
    }

    @Override
    public UserDetail selectByUserName(String username) {
        if (username!=null){
            User byUsername = userRepository.findByUsername(username);
            if (byUsername==null){
                throw new GlobalException("用户不存在");
            }
            UserDetail userDetailVo = new UserDetail();
            BeanUtils.copyProperties(byUsername,userDetailVo);
            if (userDetailVo.getDeleteTag()==1){
                return null;
            }
            return  userDetailVo;
        }
        return null;
    }
}
