package com.example.personnelmanager;

import com.example.personnelmanager.dao.SimpleJpaRepositoryImpl;
import gnu.io.CommPortIdentifier;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import javax.persistence.EntityListeners;

/**
 * springBoot启动类
 * 
 * @author Huangxiahao
 */
@EnableFeignClients
@EnableAsync
@EnableScheduling
@EnableDiscoveryClient
@SpringBootApplication
@EnableSwagger2
@EnableJpaAuditing
@EnableJpaRepositories(repositoryBaseClass = SimpleJpaRepositoryImpl.class)
public class PersonnelmanagerApplication extends SpringBootServletInitializer {

    public static void main(String[] args) {
        SpringApplication.run(PersonnelmanagerApplication.class, args);
    }

}
