package com.example.personnelmanager.common.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

/**
 * 描述：用于存放一些需要被Spring统一管理的Bean
 *
 * @author HuangXiahao
 * @version V1.0
 * @class BeanConfig
 * @packageName com.example.demo.common.config
 * @data 2020/4/21
 **/
@Configuration
public class BeanConfig {

    /**
     * Validator配置
     * @return
     */
    @Bean
    public Validator validator(){
        ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
        return validatorFactory.getValidator();
    }

    /**
     * 密码加密验证类
     **/
    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

}
