package com.example.personnelmanager.common.utils;

import com.example.personnelmanager.common.exception.GlobalException;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.*;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;

import static java.lang.Thread.sleep;

/**
 * HttpClient调用封装
 *
 * @author HuangXiahao
 * @version V1.0
 * @class AuthenticationUtils
 * @packageName com.example.personnelmanager.common.utils
 **/
@SuppressWarnings("ALL")
@Component
public class HttpClientUtil {

    @Autowired
    CookieStore cookieStore;

    private CloseableHttpClient getClient() {
        return SpringUtils.getBean("client");
    }


    public String post(String url, List<NameValuePair> param, String encode) {
        HttpPost post = new HttpPost(url);
        String result ;
        CloseableHttpResponse response = null;
        while (true){
            try {
                if (param != null) {
                    try {
                        post.setEntity(new UrlEncodedFormEntity(param));
                    } catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                CallBackThread callBackThread = new CallBackThread(post);
                callBackThread.start();
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                response = callBackThread.response;
                if (response == null) {
                    callBackThread.interrupt();
                }
                if (callBackThread.message == null || callBackThread.message == HttpStatus.SC_INTERNAL_SERVER_ERROR) {
                    try {
                        if (post != null) {
                            post.abort();
                            post.releaseConnection();
                        }
                        if (response != null) {
                            if (response.getEntity() != null) {
                                EntityUtils.consumeQuietly(response.getEntity());
                            }
                            response.close();
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw new NullPointerException("这里出现错误了重新来过");
                }else {
                    result = ResponseEntityUtil.entityToString(response, encode);
                    break;
                }
            }catch (IOException e){
                throw new GlobalException("请求接口出现错误");
            }finally {
                try {
                    if (post != null) {
                        post.abort();
                        post.releaseConnection();
                    }
                    if (response != null) {
                        if (response.getEntity() != null) {
                            EntityUtils.consumeQuietly(response.getEntity());
                        }
                        response.close();
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public String delete(String url, List<NameValuePair> param, String encode) {
        HttpDeleteWithBody  delete = new HttpDeleteWithBody (url);
        String result ;
        CloseableHttpResponse response = null;
        while (true){
            try {
                if (param != null) {
                    try {
                        delete.setEntity(new UrlEncodedFormEntity(param));
                    } catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                CallBackThread callBackThread = new CallBackThread(delete);
                callBackThread.start();
                try {
                    sleep(1000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                response = callBackThread.response;
                if (response == null) {
                    callBackThread.interrupt();
                }
                if (callBackThread.message == null || callBackThread.message == HttpStatus.SC_INTERNAL_SERVER_ERROR) {
                    try {
                        if (delete != null) {
                            delete.abort();
                            delete.releaseConnection();
                        }
                        if (response != null) {
                            if (response.getEntity() != null) {
                                EntityUtils.consumeQuietly(response.getEntity());
                            }
                            response.close();
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw new NullPointerException("这里出现错误了重新来过");
                }else {
                    result = ResponseEntityUtil.entityToString(response, encode);
                    break;
                }
            }catch (IOException e){
                throw new GlobalException("请求接口出现错误");
            }finally {
                try {
                    if (delete != null) {
                        delete.abort();
                        delete.releaseConnection();
                    }
                    if (response != null) {
                        if (response.getEntity() != null) {
                            EntityUtils.consumeQuietly(response.getEntity());
                        }
                        response.close();
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public String post(String url, String param, String encode)  {
        String result = null;
        HttpPost post = new HttpPost(url);
        CloseableHttpResponse response = null;
            try {
                if (!StringUtils.isEmpty(param)) {
                    StringEntity stringEntity = new StringEntity(param, "utf-8");
                    if (post.getHeaders(HttpHeaders.CONTENT_TYPE).length < 1) {
                        post.setHeader(HttpHeaders.CONTENT_TYPE, "application/json");
                    }
                    post.setEntity(stringEntity);
                }
                CallBackThread callBackThread = new CallBackThread(post);
                callBackThread.start();
                try {
                    sleep(1000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                response = callBackThread.response;
                if (response == null) {
                    callBackThread.interrupt();
                }
                if (callBackThread.message == null || callBackThread.message == HttpStatus.SC_INTERNAL_SERVER_ERROR) {
                    try {
                        if (post != null) {
                            post.abort();
                            post.releaseConnection();
                        }
                        if (response != null) {
                            if (response.getEntity() != null) {
                                EntityUtils.consumeQuietly(response.getEntity());
                            }
                            response.close();
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw new NullPointerException("请求接口出现错误");
                }else {
                    result = ResponseEntityUtil.entityToString(response, encode);
                }
            }catch (IOException e){
                throw new GlobalException("请求接口出现错误");
            }finally {
                try {
                    if (post != null) {
                        post.abort();
                        post.releaseConnection();
                    }
                    if (response != null) {
                        if (response.getEntity() != null) {
                            EntityUtils.consumeQuietly(response.getEntity());
                        }
                        response.close();
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        return result;
    }


    public String get(String url, String encode) {
        HttpGet get = new HttpGet(url);
        String result = null;
        CloseableHttpResponse response = null;
        while (true){
            try {
                CallBackThread callBackThread = new CallBackThread(get);
                callBackThread.start();
                try {
                    sleep(1000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                response = callBackThread.response;
                if (response == null) {
                    callBackThread.interrupt();
                }
                if (callBackThread.message == null || callBackThread.message == HttpStatus.SC_INTERNAL_SERVER_ERROR) {
                    try {
                        if (get != null) {
                            get.abort();
                            get.releaseConnection();
                        }
                        if (response != null) {
                            if (response.getEntity() != null) {
                                EntityUtils.consumeQuietly(response.getEntity());
                            }
                            response.close();
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw new NullPointerException("这里出现错误了重新来过");
                }else {
                    result = ResponseEntityUtil.entityToString(response, encode);
                    break;
                }
            }catch (IOException e){
                throw new GlobalException("请求接口出现错误");
            }finally {
                try {
                    if (get != null) {
                        get.abort();
                        get.releaseConnection();
                    }
                    if (response != null) {
                        if (response.getEntity() != null) {
                            EntityUtils.consumeQuietly(response.getEntity());
                        }
                        response.close();
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /**
     * 用于解决httpclient大量URL运行时会假死的问题
     *
     * @author HuangXiahao
     * @version V1.0
     * @class CallBackThread
     * @packageName com.example.personnelmanager.common.utils
     **/
    private class CallBackThread extends Thread {
        HttpRequestBase requestBase;
        CloseableHttpResponse response;
        Integer message;

        CallBackThread(HttpRequestBase requestBase) {
            this.requestBase = requestBase;
        }

        @Override
        public void run() {
            try {
                response = getClient().execute(requestBase);
                message = HttpStatus.SC_OK;
            } catch (IOException e) {
                message = HttpStatus.SC_INTERNAL_SERVER_ERROR;
            }
        }
    }
}
