package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.Contract;
import com.example.personnelmanager.entity.ContractImage;
import com.example.personnelmanager.entity.commonEntity.ResultObj;
import com.example.personnelmanager.entity.vo.pageableVo.ContractPageableVo;
import com.example.personnelmanager.service.ContractImageService;
import com.example.personnelmanager.service.ContractService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.NotNull;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class ContractController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/15
 **/
@RestController
@RequestMapping("/api/contract")
public class ContractController {

    /**
     * 图片保存路径
     */
    @Value("${file.imagePath}")
    String imagesFilePath;

    @Autowired
    ContractService contractService;

    @Autowired
    ContractImageService contractImageService;

    @RequestMapping(method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj addContract(@Validated(GroupSave.class) @RequestBody Contract contract) {
        Contract addContract = contractService.addEntity(contract);
        return new ResultObj(addContract, addContract != null ? "success" : "插入失败，出现未知的失败原因");
    }

    @RequestMapping(value = "/list", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj getContractPage(@RequestBody ContractPageableVo contractVo) {
        return new ResultObj(contractService.getPage(contractVo.getContract(), contractVo.getPageable()), "success");
    }

    @RequestMapping(method = RequestMethod.DELETE)
    public ResultObj delContract(@NotNull Long contractId) {
        return new ResultObj(contractService.delete(contractId), "success");
    }

    @RequestMapping(method = RequestMethod.GET)
    public ResultObj getContract(@NotNull Long contractId) {
        return new ResultObj(contractService.getOne(contractId), "success");
    }

    @RequestMapping(method = RequestMethod.PUT, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj updateContract(@Validated(GroupUpdate.class) @RequestBody Contract contract) {
        return new ResultObj(contractService.update(contract), "success");
    }

    @RequestMapping(value = "/deleteImage",method = RequestMethod.DELETE)
    public ResultObj delContractImage(@NotNull Long contractImageId) {
        return new ResultObj(contractImageService.delete(contractImageId), "success");
    }

    @RequestMapping(value = "/file", method = RequestMethod.POST)
    public ResultObj addContractImage(@RequestParam("file") MultipartFile file, @NotNull Long contractId) throws IOException {
        if (!file.isEmpty()) {
            ContractImage contractImage = new ContractImage();
            //获取文件名
            String fileName = file.getOriginalFilename();
            //获取文件后缀
            String suffixName = fileName.substring(fileName.lastIndexOf("."));
            //重新生成文件名
            fileName = UUID.randomUUID() + suffixName;
            //存入文件夹中
            file.transferTo(new File(imagesFilePath + fileName));
            Contract contract = new Contract();
            contract.setContractId(contractId);
            contractImage.setContract(contract);
            contractImage.setUrl("/images/" + fileName);
            contractImageService.addEntity(contractImage);
            return new ResultObj(contractImage, "success");
        } else {
            throw new GlobalException("文件是空的");
        }
    }

}
