package com.example.personnelmanager.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.example.personnelmanager.common.utils.DownloadFile;
import com.example.personnelmanager.common.utils.ExceptionMessage;
import com.example.personnelmanager.dao.CertificateRepository;
import com.example.personnelmanager.entity.Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.parameters.P;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.*;
import java.util.HashMap;
import java.util.Map;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class JwtController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/6/11
 **/
@RestController
public class JwtController {

    protected final Log logger = LogFactory.getLog(getClass());


    /**
     * Jwt公钥保存路径
     */
    @Value("${file.jwtFilePath}")
    String jwtFilePath;

    @RequestMapping(value = "/acceptSignature",method = RequestMethod.POST)
    public Map acceptSignature(@RequestBody String s){
        logger.info("接收到的公钥信息："+s);
        JSONObject jsonObject = JSONObject.parseObject(s);
        try {
            saveFile(jsonObject.getString("publicKey"));
            Map result = new HashMap();
            result.put("msg","上传成功");
            result.put("code","200");
            logger.info("公钥信息保存成功");
            return result;
        } catch (Exception e) {
            e.printStackTrace();
            Map result = new HashMap();
            result.put("msg","接收签名信息失败");
            result.put("code","500");
            result.put("data","接收签名信息失败"+ ExceptionMessage.getStackTraceInfo(e));
            logger.info("公钥信息接收成功");
            return result;
        }
    }

    void saveFile(String publicKey){
        try {
            File file = new File(jwtFilePath);
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            printWriter.write(publicKey);
            printWriter.flush();
            printWriter.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


}
