package com.example.personnelmanager.controller;

import com.example.personnelmanager.common.exception.GlobalException;
import com.example.personnelmanager.common.validIGroup.GroupSave;
import com.example.personnelmanager.common.validIGroup.GroupUpdate;
import com.example.personnelmanager.entity.*;
import com.example.personnelmanager.entity.commonEntity.ResultObj;
import com.example.personnelmanager.entity.vo.PeopleVo;
import com.example.personnelmanager.entity.vo.pageableVo.PeoplePageableVo;
import com.example.personnelmanager.service.CertificateService;
import com.example.personnelmanager.service.PeopleService;
import io.swagger.models.auth.In;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.NotNull;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class PeopleController
 * @packageName com.example.personnelmanager.controller
 * @data 2020/5/15
 **/
@RestController
@RequestMapping("/api/people")
public class PeopleController {

    private static final String IMAGE_FRONT_KEY = "front";

    private static final String IMAGE_BACK_KEY = "back";

    private static final String ICON_KEY = "icon";

    @Value("${file.imagePath}")
    String imagesFilePath;

    final PeopleService peopleService;

    final CertificateService certificateService;

    public PeopleController(PeopleService peopleService, CertificateService certificateService) {
        this.peopleService = peopleService;
        this.certificateService = certificateService;
    }

    @RequestMapping(method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj addPeople(@Validated(GroupSave.class) @RequestBody People people){
        People addPeople = peopleService.addEntity(people);
        return new ResultObj(addPeople,addPeople!=null?"success":"插入失败，出现未知的失败原因");
    }

    @RequestMapping(value = "/excel",method = RequestMethod.POST)
    public ResultObj AddPeopleByexcel(@RequestParam("file") MultipartFile file) throws IOException, ParseException {
        Workbook workbook  = WorkbookFactory.create(file.getInputStream());
        // 获得工作表个数
        int sheetCount = workbook.getNumberOfSheets();
        // 遍历工作表
        for (int i = 0; i < sheetCount; i++)
        {
            Sheet sheet = workbook.getSheetAt(i);
            // 获得行数
            int rows = sheet.getLastRowNum() + 1;
            Calendar calendar = Calendar.getInstance();
            for (int j = 1; j < rows; j++) {
                Row row = sheet.getRow(j);
                String name = row.getCell(0).getStringCellValue();
                String sex = row.getCell(1).getStringCellValue();
                String phone = row.getCell(2).getStringCellValue();
                String idCardNumber = row.getCell(3).getStringCellValue();
                People people = new People();
                people.setName(name);
                people.setSex(sex);
                people.setPhone(phone);
                people.setIdCardNumber(idCardNumber);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                String birthdayYear = idCardNumber.substring(6,10);
                String birthdayMonth = idCardNumber.substring(10,12);
                String birthdayDay = idCardNumber.substring(12,14);
                people.setBirthday(simpleDateFormat.parse(birthdayYear+birthdayMonth+birthdayDay).toInstant());
                people.setEntryTime(Instant.now());
                peopleService.addEntity(people);
            }
        }

        return new ResultObj("成功");
    }

    @RequestMapping(value = "/list",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj getPeoplePage(@RequestBody PeoplePageableVo peopleDto){
        return new ResultObj(peopleService.getList(peopleDto),"success");
    }

    @RequestMapping(method = RequestMethod.DELETE)
    public ResultObj delPeople(@NotNull Long peopleId){
        return new ResultObj(peopleService.delete(peopleId),"success");
    }

    @RequestMapping(method = RequestMethod.GET)
    public ResultObj getPeople(@NotNull Long peopleId){
        People one = peopleService.getOne(peopleId);
        return new ResultObj(one,"success");
    }

    @RequestMapping(method = RequestMethod.PUT,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj updatePeople(@Validated(GroupUpdate.class) @RequestBody People people){
        return new ResultObj(peopleService.update(people),"success");
    }

    @RequestMapping(value = "/leave",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj leave(@Validated(GroupSave.class) @RequestBody LeaveInformation leaveInformation){
        People leave = peopleService.leave(leaveInformation);
        return new ResultObj(leave,"success");
    }

    @RequestMapping(value = "/againEntry",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj againEntry(@Validated(GroupSave.class) @RequestBody AgainEntryInformation againEntryInformation){
        People leave = peopleService.againEntry(againEntryInformation);
        return new ResultObj(leave,"success");
    }

    @RequestMapping(value = "/becomeRegularWorker",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    public ResultObj becomeRegularWorker(@Validated(GroupSave.class) @RequestBody BecomeRegularWorkerInformation becomeRegularWorkerInformation){
        People leave = peopleService.becomeRegularWorker(becomeRegularWorkerInformation);
        return new ResultObj(leave,"success");
    }

    @RequestMapping(value = "/file",method = RequestMethod.POST)
    public People addContractImage(@RequestParam("file") MultipartFile file, @NotNull Long peopleId,String type) throws IOException {
        if (!file.isEmpty()) {
            //获取文件名
            String fileName = file.getOriginalFilename();
            //获取文件后缀
            String suffixName = Objects.requireNonNull(fileName).substring(fileName.lastIndexOf("."));
            //重新生成文件名
            fileName = UUID.randomUUID() + suffixName;
            //指定本地存入路径
            file.transferTo(new File(imagesFilePath + fileName));
            if (!StringUtils.isEmpty(type)){
                People one = peopleService.getOne(peopleId);
                if (type.equals(IMAGE_FRONT_KEY)){
                    one.setIdCardFrontUrl("/images/" + fileName);
                }else if (type.equals(IMAGE_BACK_KEY)){
                    one.setIdCardBackUrl("/images/"+fileName);
                }else if (type.equals(ICON_KEY)){
                    one.setIcon("/images/"+fileName);
                }
                peopleService.update(one);
                return one;
            }else {
                throw new GlobalException("请输入证件照片属于哪一面");
            }
        } else {
            throw new GlobalException("文件是空的");
        }
    }

}
