package com.example.personnelmanager.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.time.Instant;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class BecomeRegularWorker
 * @packageName com.example.personnelmanager.entity
 * @data 2020/5/29
 **/
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name = "become_regular_worker_information")
@ToString(exclude = {"people"})
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler","fieldHandler"})
@EntityListeners(AuditingEntityListener.class)
@Where(clause = "delete_tag = 0")
public class BecomeRegularWorkerInformation {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "become_regular_worker_information_id"  ,columnDefinition = "bigint comment '转正记录编号'")
    private Long becomeRegularWorkerInformationId;

    @Column(name = "become_regular_worker_time" , columnDefinition = "datetime comment '转正记录时间'")
    private Instant becomeRegularWorkerTime;

    @Lob
    @Column(name = "remarks",columnDefinition = "text comment '备注' ")
    private String remarks;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @ManyToOne(cascade={CascadeType.MERGE,CascadeType.REFRESH},optional = false)
    @JoinColumn(name = "people_id",columnDefinition = "bigint not null comment '人员编号'")
    private People people;

    @CreatedDate
    @Column(name = "create_time",nullable = false,columnDefinition = "datetime comment '创建时间' ")
    private Instant createTime;

    @Column(name = "delete_tag" ,nullable = false, columnDefinition = "int default 0 comment '删除标记'")
    private int deleteTag = 0;
}
